<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Twenty_Eleven
 * @since Twenty Eleven 1.0
 */
?>
<!--<!DOCTYPE html>-->
<!--[if IE 6]>
<html id="ie6" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 7]>
<html id="ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html id="ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 6) | !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="viewport" content="width=device-width" />
<title><?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 */
	global $page, $paged;

	wp_title( '|', true, 'right' );

	// Add the blog name.
	bloginfo( 'name' );

	// Add the blog description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";

	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s', 'twentyeleven' ), max( $paged, $page ) );

	?></title>
	
	
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<link rel="shortcut icon" type="image/x-icon" href="wp-content/themes/twentyeleven/images/favicon.ico">
<link href='http://fonts.googleapis.com/css?family=Open+Sans' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Advent+Pro' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Roboto+Slab' rel='stylesheet' type='text/css'>
<SCRIPT TYPE="text/javascript"> 
<!-- 
//Disable right click script 
//visit http://www.rainbow.arch.scriptmania.com/scripts/ 
//var message="Sorry, right-click has been disabled"; 
/////////////////////////////////// 
/*function clickIE() {if (document.all) {(message);return false;}} 
function clickNS(e) {if 
(document.layers||(document.getElementById&&!document.all)) { 
if (e.which==2||e.which==3) {(message);return false;}}} 
if (document.layers) 
{document.captureEvents(Event.MOUSEDOWN);document.onmousedown=clickNS;} 
else{document.onmouseup=clickNS;document.oncontextmenu=clickIE;} 
document.oncontextmenu=new Function("return false") */
// --> 
</SCRIPT> 
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js" type="text/javascript"></script>
<![endif]-->
<?php
	/* We add some JavaScript to pages with the comment form
	 * to support sites with threaded comments (when in use).
	 */
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	/* Always have wp_head() just before the closing </head>
	 * tag of your theme, or you will break many plugins, which
	 * generally use this hook to add elements to <head> such
	 * as styles, scripts, and meta tags.
	 */
	wp_head();
?>
<video controls="" autoplay="" name="media" class="video-mode" loop=""><source src="wp-content/themes/twentyeleven/mp3/shiva.MP3" type="audio/mpeg"></video>
</head>

<body>
<script>
  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

  ga('create', 'UA-46523581-1', 'sriarangalmahadevatemple.org');
  ga('send', 'pageview');

</script>
<div id="global">
<div class="ohm_slogan">
<div id="wrapper">

	<div class="header_box">
    	<div class="header">
        	<div class="temple_name">
			<a href="http://sriarangalmahadevatemple.org/" class="title1">
			<!--<img src="wp-content/themes/twentyeleven/images/temple_name.png"/>-->
			<span class="title">Major Arangal Sri Mahadevar Temple</span>
			</a>
			</div>
        </div>
        
        <div class="menu_box">
        	<ul class="menu">
            	<!--<li><a href="#">Home</a></li>
                <li><a href="#">About Temple</a></li>
                <li><a href="#">Poojas</a></li>
                <li><a href="#">Amenities Around</a></li>
                <li><a href="#">Help</a></li>
                <li><a href="#">Hymns & Bhajans</a></li>
                <li><a href="#">News</a></li>
                <li><a href="#">Photo Gallery</a></li>
                <li><a href="#">Guest Book</a></li>-->
				<?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
            </ul>
        </div>
       <?php if(is_front_page())
	   {
	   	?>
        <div class="slider_box">
        	<div class="slider_img">
			<!--<img src="wp-content/themes/twentyeleven/images/slider_img.jpg"/>-->
			<?php if ( function_exists( 'meteor_slideshow' ) ) { meteor_slideshow(); } ?>
			</div>
        </div>
		<?php } ?>
    </div>
    
